package com.ElyStudio.leGaou.activities;

import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.firebase.auth.FirebaseAuth;
import com.ElyStudio.leGaou.R;
import com.ElyStudio.leGaou.adapter.PlayingHistoryAdapter;
import com.ElyStudio.leGaou.databinding.ActivityPlayingHistoryScreenBinding;
import com.ElyStudio.leGaou.models.GetPlayingHistory;
import com.ElyStudio.leGaou.utilities.ApiController;
import com.ElyStudio.leGaou.utilities.AppCompat;
import com.ElyStudio.leGaou.utilities.CheckInternetConnection;
import com.ElyStudio.leGaou.utilities.QuizzeSnackBar;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class PlayingHistoryScreen extends AppCompat {

    ActivityPlayingHistoryScreenBinding binding;
    public static final String TAG = "PLAYING_HISTORY_SCREEN";
    
    BottomSheetDialog noInternetBottomSheet,errorOccurredBottomSheet;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivityPlayingHistoryScreenBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());
    }

    @Override
    protected void onStart() {
        super.onStart();
        getPlayingHistory();
    }

    private void getPlayingHistory(){

        Call<GetPlayingHistory> getPlayingHistoryCall = ApiController.getInstance().getApi().getPlayingHistoryCall(FirebaseAuth.getInstance().getUid());

        getPlayingHistoryCall.enqueue(new Callback<GetPlayingHistory>() {
            @Override
            public void onResponse(Call<GetPlayingHistory> call, Response<GetPlayingHistory> response) {
                if(response.body().getStatusCode() == 0)
                {
                    if(response.body().getPlayingHistoryList() != null)
                    {
                        binding.playingHistoryRecyclerview.setLayoutManager(new LinearLayoutManager(PlayingHistoryScreen.this,LinearLayoutManager.VERTICAL,false));
                        binding.playingHistoryRecyclerview.setAdapter(new PlayingHistoryAdapter(PlayingHistoryScreen.this,PlayingHistoryScreen.this,response.body().getPlayingHistoryList(),response.body().getAdEnabled(),response.body().getNativeAdId()));
                    }
                }
                else
                {
                    showErrorOccurredBottomSheet();
                }
            }

            @Override
            public void onFailure(Call<GetPlayingHistory> call, Throwable t) {
                showErrorOccurredBottomSheet();
                Log.d(TAG,"getPlayingHistoryCall Failure = "+t.getLocalizedMessage());
            }
        });

    }
    public void showNoInternetBottomSheet(){

        noInternetBottomSheet = new BottomSheetDialog(PlayingHistoryScreen.this);
        View view = LayoutInflater.from(PlayingHistoryScreen.this).inflate(R.layout.error_occurred_bottom_sheet,findViewById(R.id.errorOccurredBottomSheetLayout),false);
        noInternetBottomSheet.setContentView(view);

        Button contactSupportBtn = noInternetBottomSheet.findViewById(R.id.bottomSheetSecondaryButton);
        Button tryAgainBtn = noInternetBottomSheet.findViewById(R.id.bottomSheetPrimaryButton);
        ImageView bottomSheetIllustration = noInternetBottomSheet.findViewById(R.id.bottomSheetIllustraton);
        TextView bottomSheetTitle = noInternetBottomSheet.findViewById(R.id.bottomSheetTitle);
        noInternetBottomSheet.setCancelable(false);
        TextView bottomSheetSubText = noInternetBottomSheet.findViewById(R.id.bottomSheetSubText);
        contactSupportBtn.setVisibility(View.GONE);

        tryAgainBtn.setText(getResources().getString(R.string.try_again));

        tryAgainBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(CheckInternetConnection.isInternetConnected(PlayingHistoryScreen.this))
                {
                    noInternetBottomSheet.cancel();
                    getPlayingHistory();
                }
                else
                {
                    QuizzeSnackBar.showSnackBar(PlayingHistoryScreen.this,view,getResources().getString(R.string.no_internet),getResources().getColor(R.color.error));
                }
            }
        });

        bottomSheetTitle.setText(getResources().getString(R.string.no_internet));
        bottomSheetSubText.setText(getResources().getString(R.string.no_internet_sub_text));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable(PlayingHistoryScreen.this,R.drawable.no_conection_illustration));

        if(!PlayingHistoryScreen.this.isFinishing())
        {
            noInternetBottomSheet.show();
        }

    }

    public void showErrorOccurredBottomSheet(){

        errorOccurredBottomSheet = new BottomSheetDialog(PlayingHistoryScreen.this);
        View view = LayoutInflater.from(PlayingHistoryScreen.this).inflate(R.layout.error_occurred_bottom_sheet,findViewById(R.id.errorOccurredBottomSheetLayout),false);
        errorOccurredBottomSheet.setContentView(view);
        errorOccurredBottomSheet.setCancelable(false);
        Button contactSupportBtn = errorOccurredBottomSheet.findViewById(R.id.bottomSheetSecondaryButton);
        Button tryAgainBtn = errorOccurredBottomSheet.findViewById(R.id.bottomSheetPrimaryButton);
        ImageView bottomSheetIllustration = errorOccurredBottomSheet.findViewById(R.id.bottomSheetIllustraton);
        TextView bottomSheetTitle = errorOccurredBottomSheet.findViewById(R.id.bottomSheetTitle);
        TextView bottomSheetSubText = errorOccurredBottomSheet.findViewById(R.id.bottomSheetSubText);

        bottomSheetTitle.setText(getResources().getString(R.string.some_error_occurred));
        bottomSheetSubText.setText(getResources().getString(R.string.error_subtext));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable(PlayingHistoryScreen.this,R.drawable.error_illustration));
        contactSupportBtn.setText(getResources().getString(R.string.contact_support));
        tryAgainBtn.setText(getResources().getString(R.string.try_again));

        contactSupportBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(PlayingHistoryScreen.this, SupportScreen.class));
            }
        });

        tryAgainBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                errorOccurredBottomSheet.cancel();
                getPlayingHistory();
            }
        });

        if(!PlayingHistoryScreen.this.isFinishing())
        {
            errorOccurredBottomSheet.show();
        }
    }
}